function showDM(varargin)
% ShowDM(filename);
% ShowDM(dm,[v],[hideTxt],[grayColormap]);
%
% function uses the patch command to display the DM actuators and their
% commanded value
%
% Inputs: 
%   dm           [1xNumActuators struct]  structure output from LoadDM
%       dm(k).pts   [1x1 double]          ??
%       dm(k).ch    [1x1 double]          software channel used by the k'th actuator 
%       dm(k).x     [1xNumSides+1 double] x coordinates of actuator corners
%       dm(k).y     [1xNumSides+1 double] y coordinates of actuator corners
%       dm(k).v     [1x1 double]          voltage command for the k'th actuator
%       dm(k).g     [1x1 double]          Actuator group index
%   v            [1xNumActuators double]  (Optional) Voltages to display (replaces dm.v)
%   hideTxt      [1x1 bool]               (Optional) true to supress text from display (false default)
%   grayColormap [1x1 bool]               (Optional) true to use gray colormap, 
%                                           false to not specify (true default).
%
% Example:
%   dm = LoadDM('DMfile.AOS');
%   figure; ShowDM(dm);
%       or
%   cmds = 0.5.* ones(1,length(dm));
%   hideTxt = true; grayColormap = true;
%   figure; ShowDM(dm,cmds,hideTxt,graycolormap);
% SEE ALSO: CreateDMSurface

%% begin code

% specify defaults
hideTxt = false;            % true to hide text overlay
grayColormap = true;        % true to apply a gray colormap

% parse inputs
dm = varargin{1};
if (ischar(dm))
    dm = LoadDM(dm);
end;
if nargin>1 && ~isempty(varargin{2})
    v = varargin{2};
    v = num2cell(v);  % place each value in its own cell
    [dm.v]=deal(v{:}); % deal the values to the structure
end
try         % by using try, these values will be left as the default specified above if they are not passed in
    hideTxt      = varargin{3};
    grayColormap = varargin{4};
end
    
% display DM 
for ii=1:length(dm);
    patch(dm(ii).x,dm(ii).y,dm(ii).v);      % display the actuator    
    hold on;
    if ~hideTxt                             % overlay channel, voltage and group
        %changed by JDM on 9/5/08
        text(mean(dm(ii).x),mean(dm(ii).y),...
            sprintf('ch:%i\nv:%i\ng:%i',dm(ii).ch,dm(ii).v,dm(ii).g),'Color','g');
            %sprintf('ch:%i\nv:%i\ng:%i',ii,dm(ii).v,dm(ii).g),'Color','g'); 
    end
end;
if grayColormap; colormap(gray); end        % set the colorbar

return;